function set_scenario( obj , scenario_list )
%SET_SCENARIO Assigns random scenarios to each segment
%
%   SET_SCENARIO( scenario_list ) assigns a random scenario to each segment of the
%   track or track array. scenario_list must be a single string or a cell array
%   containing a set of strings. Also make sure that the scenario is supported by
%   the parameter_set class.
% 
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
% 
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published 
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.

% Parse input arguemtns
if iscell( scenario_list )
    no_scenario_list = numel( scenario_list );
    for n=1:no_scenario_list
        if ~scenario_list{n}
            error('??? all elements of "scenario_list" must be strings.');
        end
    end
elseif ischar( scenario_list )
    scenario_list_old = scenario_list;
    scenario_list = cell(1,1);
    scenario_list{1} = scenario_list_old;
    no_scenario_list = 1;
else
    error('??? "scenario_list" must a string or cell array.');
end

% Set a random scenarion from scenario_list to each segment
for n = 1:numel( obj )
    for m = 1:numel( obj(n).scenario )
        obj(n).scenario{m} = scenario_list{ randi( no_scenario_list ) };
    end
end

end

