function [ scenarios , config_folder , file_names ] = supported_scenarios( parse_shortnames )
%SUPPORTED_SCENARIOS Returns a list of supported scenarios
%
%   The optional parameter "parse_shortnames" can disable the shortname
%   parsing. This is significantly faster.
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
%
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.

% Parse input variables.
if nargin > 0
    parse_shortnames = logical(parse_shortnames(1));
else
    parse_shortnames = true;
end

information = what('@parameter_set');
config_folder = regexprep(information.path,'@parameter_set',['config',filesep]);

files = dir([config_folder,'*.conf']);
nfiles = numel(files);

scenarios = cell(1,1000);
if parse_shortnames
    file_names = cell(1,1000);
end

m = 0;
for n = 1 : nfiles
    m = m + 1;
    [~, scenarios{m}] = fileparts( files(n).name );
    
    if parse_shortnames
        file_names_tmp = scenarios{m};
        file_names{m} = file_names_tmp;
        
        % Read the file content to find short names for the scenario
        file = fopen([config_folder,scenarios{m},'.conf'],'r');
        lin = fgets(file);
        while ischar(lin)
            p1 = regexp(lin,'[ \t]*ShortName[ \t]*=[ \t]*[A-Za-z0-9_]+');
            if p1 == 1
                short_name = ...
                    regexp( lin,...
                    '(?<=^[ \t]*ShortName[ \t]*=[ \t]*)[A-Za-z0-9_]+',...
                    'match');
                
                if any( strcmp( short_name{1} , scenarios(1:m) ) )
                    error( ['ShortName "',short_name{1},'" in "',file_names_tmp,'" is ambiguous.'] )
                end
                
                m = m+1;
                scenarios{m} = short_name{1};
                file_names{m} = file_names_tmp;
            end
            lin = fgets(file);
        end
        fclose(file);
    end
end
scenarios = scenarios(1:m);
if parse_shortnames
    file_names = file_names(1:m);
else
    file_names = scenarios;
end
end

