function set_scenpar( obj,sp,pl,check )
%SET_SCENPAR Sets the scenpar and plpar properties of all objects 
%
%   SET_SCENPAR( sp,pl ) replaces the values scenpar and plpar by the 
%   given values in sp and pl.
%   
%   Example:
%   p.set_scenpar( p(1).scenpar,p(1).plpar )
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
% 
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published 
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.

if nargin<4
    check = true;
end

if numel(obj) > 1
    % Do for parameter_set_arrays
    for n=1:numel(obj)
        obj(n).set_scenpar(sp,pl,check);
    end
    
elseif obj.no_positions > 0
    if check
        obj.scenpar = sp;
        obj.plpar = pl;
    else
        obj.Pscenpar = sp;
        obj.Pplpar = pl;
    end
end

end

