function set_par( obj , name , value )
%SET_PAR Sets the parameters of all objects in parameter_set array
%
%   SET_PAR( name,value ) sets all values of the parameter specified by 
%   'name'  of the 'parameter-set'-array to the given value.
%   Example: set_par( 'ds' , 1e-9 ) sets all ds-values to one ns.
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
% 
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published 
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.

supported_types = { 'ds','kf','sf','asD','asA','esD','esA',...
    'samples_per_meter','map_extension_space'};

if ~( ischar(name) && any( strcmpi(name,supported_types)) )
    str = 'Name not found; supported types are: ';
    no = numel(supported_types);
    for n = 1:no
        str = [str,supported_types{n}];
        if n<no
            str = [str,', '];
        end
    end
    error(str);
end

if ~( all(size(value) == [1,1]) && isnumeric(value) && isreal(value) )
    error('??? "value" must be scalar and numeric')
end

for n = 1:numel(obj)
    eval( [ 'obj(n).',name,' = ones( 1,numel(obj(n).',name,') )*value;' ] );
end

end

