function set_LSP_xcorr_matrix( obj , M )
%SET_LSP_XCORR_MATRIX Sets the xcorr-matrix of all objescts in parameter_array
%
%   SET_LSP_XCORR_MATRIX( M ) sets all xcorr-matrices of the
%   parameter_set-array.
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
% 
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published 
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.

if ~all( size(M) == [7,7] )
    error('QuaDRiGa:Parameter_set:wrongInputValue',...
        'LSP_xcorr_matrix must be of size [7x7]')
end

if ~all( diag(M) == ones(7,1) )
    error('QuaDRiGa:Parameter_set:wrongInputValue',...
        'LSP_xcorr_matrix must have all ones on main diagonal')
end

if any(any( M>1 | M<-1 ))
	error('QuaDRiGa:Parameter_set:wrongInputValue',...
        'Entries in LSP_xcorr_matrix be in between -1 and 1')
end

sp = obj.scenpar;

sp.ds_kf = M( 1,2 ) ;
sp.ds_sf = M( 1,3 ) ;
sp.asD_ds = M( 1,4 ) ;
sp.asA_ds = M( 1,5 ) ;
sp.esD_ds = M( 1,6 ) ;
sp.esA_ds = M( 1,7 ) ;
sp.sf_kf = M( 2,3 ) ;
sp.asD_kf = M( 2,4 ) ;
sp.asA_kf = M( 2,5 ) ;
sp.esD_kf = M( 2,6 ) ;
sp.esA_kf = M( 2,7 ) ;
sp.asD_sf = M( 3,4 ) ;
sp.asA_sf = M( 3,5 ) ;
sp.esD_sf = M( 3,6 ) ;
sp.esA_sf = M( 3,7 ) ;
sp.asD_asA = M( 4,5 ) ;
sp.esD_asD = M( 4,6 ) ;
sp.esA_asD = M( 4,7 ) ;
sp.esD_asA = M( 5,6 ) ;
sp.esA_asA = M( 5,7 ) ;
sp.esD_esA = M( 6,7 ) ;

obj.scenpar = sp;

end
