function [ channel_obj, cb  ] = get_channels( obj )
%GET_CHANNELS Generates channel coefficients
%
%   c = GET_CHANNELS generates the channel coefficients. This is
%   the main function of the channel builder. 
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
% 
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published 
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.


[N,O] = size(obj);

m = 1;
for n=1:N
    for o=1:O
        if obj(n,o).no_positions > 0
            cb(m) = channel_builder( obj(n,o) );
            m = m+1;
        end
    end
end

channel_obj = cb.get_channels;

end

