function angles = get_angles( obj )
%GET_ANGLES Calculates the angles between Rx and Tx
%
%   GET_ANGLES returns the angles between Receiver (Rx) and Transmitter
%   (Tx). Here, some of the core functions of "layout2link" from the
%   original WINNER code are implemented.
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
% 
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published 
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.

% Initialize memory
angles = zeros( 4,obj.no_positions );

% ThetaBs 
angles(1,:) = atan2( obj.positions(2,:) - obj.tx_position(2) , ...
    obj.positions(1,:) - obj.tx_position(1) );

% ThetaMs 
angles(2,:) = pi + angles(1,:);

% EaBs
angles(3,:) = atan( ( obj.positions(3,:) - obj.tx_position(3) ) ./ ...
    sqrt( (obj.tx_position(1) - obj.positions(1,:)).^2 +...
    (obj.tx_position(2,:) - obj.positions(2,:)).^2 ) );

% When Rx and Tx are at the same position, the angle is NaN
% We set it to 0 instead.
angles(3, isnan( angles(3,:) ) ) = 0;

% EaMs
angles(4,:) = -angles(3,:);

% Mapping to (-180,180) degrees
angles = angles * 180/pi;
angles = mod( angles , 360);
angles = angles - 360*floor(angles/180);

end

