function [layoutpar,wimpar]  =  winner_compatibe_output( obj )
%WINNER_COMPATIBE_OUTPUT Create Winner-compatible output data structures
%
%   wim_array = WINNER_COMPATIBE_OUTPUT generates an data structure that is
%   compatible with the Wim2/Win+ channel model.
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
% 
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published 
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.

m = 1;
for n = 1:obj.no_tx
    Stations(m) = obj.tx_array(n).winner_compatibe_output;
    Stations(m).Name = [ obj.tx_name{n},' ', obj.tx_array(n).name ];
    Stations(m).Pos = obj.tx_position(:,n);
    Stations(m).Rot = [0;0;0];
    Stations(m).Height = NaN;
    Stations(m).Velocity = [0;0;0];
    m=m+1;
end

winner_scen = { 'A1', 'A2', 'B1', 'B2', 'B3', ...
    'B4', 'B5a', 'B5c', 'B5f', 'C1', 'C2', 'C3', 'D1', 'D2a' };

for n = 1:obj.no_rx
    Stations(m) = obj.rx_array(n).winner_compatibe_output;
    Stations(m).Name = [ obj.rx_name{n},' ', obj.rx_array(n).name ];
    Stations(m).Pos = obj.rx_position(:,n);
    Stations(m).Rot = [0;0;obj.track(n).ground_direction(1)];
    Stations(m).Height = NaN;
    
    if ~all( obj.track(n).ground_direction > obj.track(n).ground_direction(1)-0.01 & ...
        obj.track(n).ground_direction < obj.track(n).ground_direction(1)+0.01 )
       error(['WINNER only supports linear tracks. ',obj.rx_name{n},' is incompatible.']) 
    end
    
    no_snap = obj.track(n).no_snapshots;
    Velocity = obj.track(n).positions(:,end) - obj.track(n).positions(:,1);
    Velocity = Velocity .* 3 / sum( Velocity.^2 )^0.5;
    Stations(m).Velocity = Velocity;
    m=m+1;
    
    if ~all( size(obj.track(n).scenario) == [1 1] )
        error(['WINNER only a single scenario type for each user position.']) 
    end
    
    scen = regexp( obj.track(n).scenario{1} ,'[A-D]+[1-5]+[acf]*' ,'match');
    cond = regexp( obj.track(n).scenario{1} ,'(?<=[A-D]+[1-5]+[acf]*)[nl]+' ,'match');
    if ~any( find(strcmp(scen,winner_scen)) ) || isempty(cond)
        error(['WINNER does not support the scenario ' , obj.track(n).scenario{1}]) 
    end
    ScenarioVector(n) = find(strcmp(scen,winner_scen));
    PropagConditionVector(n) = find( strcmp(cond,{'n','l'}) )-1;
    NumTimeSamples(n) = obj.track(n).no_snapshots;
end

layoutpar = struct('Stations', Stations,...
    'NofSect', ones(1,obj.no_tx),...
    'Pairing', [ obj.pairing(1,:) ;  obj.pairing(2,:) + obj.no_tx ] ,...
    'StreetWidth',20*ones(1,obj.no_links),...
    'Dist1',NaN(1,obj.no_links),...
    'ScenarioVector',ScenarioVector,... % A1, A2, B1, B2, B3, B4, B5a, B5c, B5f, C1, C2, C3, D1, D2a
    'PropagConditionVector',PropagConditionVector,...
    'NumFloors', 1*ones(1,obj.no_links),...   % The ground floor is number 1
    'NumPenetratedFloors',0*ones(1,obj.no_links));

wimpar=struct(  'Scenario',winner_scen{ScenarioVector(1)},...  % WINNER scenario
                'range',1,...  
                'end_time',1,...                        % Observation end time for B5 - time points are taken as:  wimpar.TimeVector=linspace(0,wimpar.end_time,T);
                'SampleDensity', obj.simpar.sample_density,...    % in samples/half-wavelength
                'NumTimeSamples',ceil( mean( NumTimeSamples ) ),...         
                'UniformTimeSampling','no',... 
                'IntraClusterDsUsed','yes',...           % Two strongest clusters are divided into three subclusters
                'NumSubPathsPerPath',20,...             % only value supported is 20.
                'FixedPdpUsed','no',...                 % Use fixed delays and path powers
                'FixedAnglesUsed','no',...              % Use fixed AoD/AoAs and EoD/EoAs
                'PolarisedArrays','yes',...             % Obsolite - always polarised arrays are used!
                'TimeEvolution','no',...                % use of time evolution option
                'CenterFrequency',obj.simpar.center_frequency,...       % in Herz
                'DelaySamplingInterval',5e-9,...        
                'PathLossModelUsed','yes',...            
                'ShadowingModelUsed','yes',...           
                'PathLossModel','pathloss',...
                'PathLossOption','CR_light',...         % 'CR_light' or 'CR_heavy' or 'RR_light' or 'RR_heavy', CR = Corridor-Room, RR = Room-Room nlos
                'RandomSeed',[],...                     % if empty, seed is not set. 
                'UseManualPropCondition','yes');

end

