function set_pairing( obj , method , test )
%SET_PAIRING Get list of all links
%
%   SET_PAIRING fills the link list so that all links (each Tx to each Rx)
%   are going to be simulated.
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
% 
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published 
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.

if nargin == 1
    method = 'all';
    test = false;
elseif nargin == 2;
    test = true;
end

if test
    supported_types = {'all'};
    
    if ~( ischar(method) && any( strcmpi(method,supported_types)) )
        str = '??? "method" is not supported. Use: ';
        no = numel(supported_types);
        for n = 1:no
            str = [str,supported_types{n}];
            if n<no
                str = [str,', '];
            end
        end
        error(str);
    end
end

switch method
    case 'all'
        pairs = zeros( 2, obj.no_tx*obj.no_rx );
        for n = 1:obj.no_tx
            pairs( 1, (n-1)*obj.no_rx+1 : n*obj.no_rx ) = n;
            pairs( 2, (n-1)*obj.no_rx+1 : n*obj.no_rx ) = 1:obj.no_rx;
        end
        obj.pairing = pairs;
end

end

