function randomize_rx_positions( obj , max_dist , min_height , max_height , track_length )
%RANDOMIZE_RX_POSITIONS Generate random Rx positions and tracks
%
%   RANDOMIZE_RX_POSITIONS( max_dist , min_height , max_height , track_length) 
%   populates the network with random users. 'max_dist' is the maximum distance 
%   from the layout center in m. 'min_height' and 'max_height' describe the
%   height restrictions for the user positions. All user tracks are linear
%   with 1 m length.
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
% 
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published 
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.

if nargin == 1
    max_dist = 50;
    min_height = 0;
    max_height = 10;
    track_length = 1;
elseif nargin == 2
    min_height = 0;
    max_height = 10;
    track_length = 1;
elseif nargin == 3
    max_height = 10;
    track_length = 1;
elseif nargin == 4
    track_length = 1;
end

% Check inputs
if ~( all(size(max_dist) == [1 1]) &&...
        isnumeric(max_dist) &&...
        isreal(max_dist) &&...
        max_dist > 0 )
    error('??? "maximum_distance" must be a real scalar  > 0')
end

if ~( all(size(min_height) == [1 1]) &&...
        isnumeric(min_height) &&...
        isreal(min_height) )
    error('??? "min_height" must be a real scalar')
end

if ~( all(size(max_height) == [1 1]) &&...
        isnumeric(max_height) &&...
        isreal(max_height) )
    error('??? "max_height" must be a real scalar  > 0')
end

if ~( all(size(track_length) == [1 1]) &&...
        isnumeric(track_length) &&...
        isreal(track_length) )
    error('??? "track_length" must be a real scalar  > 0')
end


% Generate random positions and tracks
rx_position_new = obj.rx_position;
for n = 1:obj.no_rx
    
    a = (2*rand-1)*max_dist + 1j*(2*rand-1)*max_dist;
    while abs(a)>max_dist
        a = (2*rand-1)*max_dist + 1j*(2*rand-1)*max_dist;
    end
    
    b = rand * (max_height - min_height) + min_height;
    
    rx_position_new(:,n) = [ real(a) ; imag(a) ; b ];
    
    obj.track(n).generate( 'linear',track_length );
    obj.track(n).name = ['Rx',num2str(n,'%04.0f')];
    if track_length>0
        obj.track(n).interpolate_positions( obj.simpar.samples_per_meter );
        obj.track(n).compute_directions;
    end
    scenarios = cell(obj.no_tx,1);
    for m=1:obj.no_tx
        scenarios(m) = obj.track(n).scenario(1);
    end
    obj.track(n).scenario = scenarios;
end

obj.rx_position = rx_position_new;
end