function bulk_parameters = winner_compatible_bulkpar(obj)
%WINNER_COMPATIBE_BULKPAR Create Winner-compatible output data structures
%
%   bulk_parameters = WINNER_COMPATIBE_BULKPAR generates an data structure that is
%   compatible with the Wim2/Win+ channel model.
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
%
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.


L = obj.par.scenpar.NumClusters;                            % no. taps
N = obj.par.no_positions;                                   % no. positions

generate_initial_paths(obj);
generate_initial_angles(obj);

[aod, aoa, eod, eoa] = get_subpath_angles(obj);

phi = 360*rand(N, L, 20);                                     % random phases for all users, Uni(0, 360)

sigmas = [obj.par.asD; obj.par.asA; obj.par.ds; ...      % Correlataion parameters
    obj.par.sf; obj.par.kf; obj.par.esD; obj.par.esA]';

bulk_parameters = struct('delays', obj.taus, ...
    'path_powers', obj.pow_wo_kf, ...
    'aods', aod, ...                                          % in degrees
    'aoas', aoa, ...                                          % in degrees
    'eods', eod, ...                                          % in degrees
    'eoas', eoa, ...                                          % in degrees
    'subpath_phases', phi, ...                                % in degrees
    'path_losses', ones(N, 1), ...                            % in linear scale
    'MsBsDistance', obj.par.get_distances, ...
    'shadow_fading', obj.par.sf, ...                          % in linear scale
    'sigmas', sigmas, ...
    'propag_condition', ones(1, N).', ...
    'user_indeces', (1:N)', ...
    'Kcluster', sigmas(:, 5)');

end
