function set_rx_array(obj, new_array)
%SET_RX_ARRAY Changes the rx array for all users in the current channel builder
%
%   SET_RX_ARRAY(new_array) allows replaces the receive array of each
%   user in the current channel builder object with the "new_array".
%   "new_array" must be a scalar object of the "array" class. This allows
%   to run the same simulations (using the same random seeds) with
%   different antenna patterns.
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
%
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.

if ~(isa(new_array, 'array') && numel(array) == 1)
    error('"new_array" must be a scalar object of the "array" class');
end

for n = 1:numel(obj)
    for m = 1:numel(obj(n).rx_array)
        obj(n).rx_array(m) = new_array;
    end
end

end
