function wim_array = winner_compatibe_output( obj )
%WINNER_COMPATIBE_OUTPUT Create Winner-compatible output data structures
%
%   wim_array = WINNER_COMPATIBE_OUTPUT generates an data structure that is
%   compatible with the Wim2/Win+ channel model.
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
% 
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published 
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.


wim_array.Name = obj.name;
wim_array.Pos = [];
wim_array.Rot = [];
wim_array.Height = [];
wim_array.Velocity = [];

for n = 1:obj.no_elements
	wim_array.Element(n).Pos = obj.element_position(:,n);
    wim_array.Element(n).Rot = zeros( size(obj.element_position(:,n)) );
end

wim_array.FP.AzGrid = obj.azimuth_grid;
wim_array.FP.ElGrid = obj.elevation_grid;

wim_array.FP.VerAzElFP = obj.field_pattern_vertical;
wim_array.FP.HorAzElFP = obj.field_pattern_horizontal;
wim_array.FP.InterpMethod = 'linear';
wim_array.FP.NrOfElem = obj.no_elements;

end

