function apply_common_phase( h_array , element )
%APPLY_COMMON_PHASE Applys the common phase to the patterns
%
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
%
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.

% Parse input variables.
if exist('element','var')
    if ~( size(element,1) == 1 && isnumeric(element) ...
            &&  all( mod(element,1)==0 ) && min(element) > 0 && max(element) ...
            <= h_array.no_elements )
        error('??? "element" must be integer > 0 and can not exceed array size')
    end
else
    element = 1:h_array.no_elements ;
end

no_az = h_array.no_az;
no_el = h_array.no_el;
no_element = numel(element);

fpV = zeros(no_el,no_az,no_element);
fpH = zeros(no_el,no_az,no_element);
for n = 1:no_element
   cp = exp(1j*h_array.common_phase(:,:,element(n)));
   fpV(:,:,n) = h_array.field_pattern_vertical(:,:,element(n)) .* cp;
   fpH(:,:,n) = h_array.field_pattern_horizontal(:,:,element(n)) .* cp;
end

h_array.field_pattern_vertical(:,:,element) = fpV;
h_array.field_pattern_horizontal(:,:,element) = fpH;
h_array.common_phase(:,:,element) = zeros(no_el,no_az,no_element);

end

