function generate_initial_xpr( h_channel_builder )
%GENERATE_INITIAL_XPR Generates the initial XPR values

L = h_channel_builder.par.scenpar.NumClusters;      	% no. taps
N = h_channel_builder.par.no_positions;                 % no. positions
oL = ones(1,L-1);
oP = ones(1,20);

% We get the mean value from the parameter set and add a additional spread
% for the NLOS cluster. THis spread is equal to the original XPR-sigma.
xpr_mu      = h_channel_builder.par.xpr.'; 
xpr_sigma   = h_channel_builder.par.scenpar.xpr_sigma;

%% Linear Polarization

xpr_cluster = randn(N,L-1)*xpr_sigma + 10*log10(xpr_mu) * oL ;
xpr_cluster = 10.^( 0.1*xpr_cluster );

% To keep the XPR from the parameter set, we normalize the XPRs from the
% clusters. THis needs to consider the NLOS path powers. 
P = h_channel_builder.pow;
P = P(:,2:end) ./ (mean( P(:,2:end) , 2 ) * oL);
norm = (xpr_cluster.*P) ./ ( xpr_mu*oL ) ./ P;
xpr_cluster = xpr_cluster ./ norm ;

% Now we repeat the same procedure for the sub-paths.
% Powers are equally distributed for the sub-paths.
xpr_subpath = randn(N,L-1,20)*xpr_sigma + 10*log10( xpr_cluster(:,:,oP) );
xpr_subpath = 10.^( 0.1*xpr_subpath );
norm = xpr_subpath ./ xpr_cluster(:,:,oP);
xpr_subpath = 10*log10( xpr_subpath ./ norm );

% Set the LOS XPR and copy data to the cahnnel builder
h_channel_builder.xpr = cat( 2, ones(N,1,20) * Inf , xpr_subpath );


%% Circular Polarization

% Set the XPR for the circular polarization
xpr_cluster = randn(N,L-1)*xpr_sigma + 10*log10(xpr_mu) * oL ;
xpr_cluster = 10.^( 0.1*xpr_cluster );

rand_sign = 2*( randi(2,size(xpr_cluster))-1.5 );

kappa_cluster = [zeros( N,1 ) , rand_sign.*acot( sqrt(xpr_cluster) ) ];
h_channel_builder.kappa = kappa_cluster(:,:,oP);


%% Random Polarization

h_channel_builder.random_pol = (rand(4,L*20,N)*2*pi - pi);

end

