function copy_element( obj, source, target )
%COPY_ELEMENT Creates a copy of an antenna element
%
%   COPY_ELEMENT(source,target) copies the element from source to target. 
%   Source must be an index of the array object. The value must be scalar, 
%   integer and greater than 0 and it can not exceed the array size. 
%   Target can be any number > 0.
% 
% QuaDRiGa Copyright (C) 2011-2012 Fraunhofer Heinrich Hertz Institute
% e-mail: quadriga@hhi.fraunhofer.de
% 
% QuaDRiGa is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published 
% by the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.


% Parse input arguments
if ~( size(source,1) == 1 && isnumeric(source) && all(size(source) == [1 1]) ...
        &&  all( mod(source,1)==0 ) && min(source) > 0 && max(source)<=obj.no_elements )
    error('??? "source" must be scalar, integer > 0 and can not exceed array size')
end

if ~( size(target,1) == 1 && isnumeric(target) ...
        &&  all( mod(target,1)==0 ) && min(target) > 0)
    error('??? "target" must be integer > 0')
end

if target > obj.no_elements
    obj.no_elements = max(target);
end

% Copy the data from source to target
target = setdiff(target,source);
for n=1:numel(target)
   obj.element_position(:,target(n)) = obj.element_position(:,source);
   obj.field_pattern_vertical(:,:,target(n)) = obj.field_pattern_vertical(:,:,source);
   obj.field_pattern_horizontal(:,:,target(n)) = obj.field_pattern_horizontal(:,:,source);
   obj.common_phase(:,:,target(n)) = obj.common_phase(:,:,source);
   obj.pol_vector(:,target(n)) = obj.pol_vector(:,source);
end

end

