function ang_new = rescale_departure_angles( spread, ang, pow, upd )
%RESCALE_DEPARTURE_ANGLES 

N  = numel(spread);
oN = ones(N,1);
L  = size(ang,2);
oL = ones(1,L);

aso       = qf.calc_angular_spreads( ang,pow );

% Calculate the mean angle for the fixed angles
mean_ang = zeros( N,1 );
for n = 1:N
    ii = ~upd(n,:);
    mean_ang(n) = angle( sum( pow(n,ii).*exp( 1j*ang(n,ii) ) , 2 ) ); % [rad]
end

ang = ang - mean_ang(:,oL);
ang = mod( ang + pi, 2*pi) - pi;

chn = true(N,1);
cnt = 0;

scale_new = spread ./ aso;
scale     = oN;
step_size = scale_new-1;
ang_new   = ang;
aso_new   = aso;

while any(chn) && cnt < 20
    
    scale_new(chn) = scale(chn) + step_size(chn);
    ang_new(chn,:) = ang(chn,:) .* scale_new(chn,oL);
    ang_new(~upd)  = ang(~upd);
    aso_new(chn)   = qf.calc_angular_spreads( ang_new(chn,:),pow(chn,:) );
    
    ind = abs( spread - aso_new ) < abs( spread - aso );
    
    % Reduce step size and change direction
    step_size( ~ind ) = -0.37 * step_size( ~ind );
    
    scale( ind ) = scale_new( ind );
    aso( ind )   = aso_new( ind );
    
    chn = chn & abs( step_size ) > 1e-6;
    cnt = cnt + 1;
end

ang_new = ang_new + mean_ang(:,oL);

end
