% This file contains the reference values from the 3GPP calibration

%%  Data for the 3GPP 36.873 Phase 1 Calibration
cl36873a(1,:) = -[134,120.2,115.9,112.6,109.9,107.6,105.4,103.4,101.6,99.9,98.2,96.5,...
  94.8,92.9,90.9,88.5,85.7,81.8,76,69.3,49.2];
cl36873a(2,:) = -[147.3,128.8,123.9,120.5,117.7,115.1,112.7,110.3,107.9,105.5,103,...
  100.3,97.5,94.8,91.9,88.7,84.7,79.5,72.7,63.9,46.5];
cl36873a(3,:) = -[144.7,132.1,129,126.4,124.3,122.2,120.2,118.3,116.3,114.3,112.3,...
  110.3,108.2,106.1,104,101.7,99.1,95.8,91.6,84.1,59.8];
cl36873a(4,:) = -[154,133.3,129.9,127.5,125.3,123.3,121.3,119.2,117.1,114.9,112.3,...
  109.6,106.8,104,101.1,98.2,95.1,91.2,86.5,78.9,54.2];

gf36873a(1,:) = [-6.9,-2.2,-0.9,0,0.8,1.6,2.4,3.4,4.3,5.3,6.4,7.5,8.7,10.1,11.6,13.4,15.3,...
  17.5,20.2,23.4,26.8];
gf36873a(2,:) = [-11.2,-1.7,-0.4,0.6,1.5,2.4,3.4,4.5,5.6,6.8,8.1,9.5,10.9,12.5,14.2,16.1,...
  18.3,20.7,23.3,25.6,26.9];
gf36873a(3,:) = [-8.4,-3.1,-1.9,-0.9,-0.1,0.6,1.4,2.2,3,4,4.9,6,7.2,8.5,9.9,11.6,13.5,...
  15.9,18.8,22.6,26.7];
gf36873a(4,:) = [-12.8,-1.4,-0.1,0.8,1.7,2.7,3.7,4.8,5.9,7.1,8.4,9.8,11.2,12.8,14.5,16.4,...
  18.5,20.7,23.2,25.4,26.9];

zod36873a(1,:) = [48.1,83.5,86.3,87.8,88.7,89.4,89.7,89.9,90.6,91.1,91.5,92,92.6,93.3,94,...
    94.7,95.6,96.7,98.5,101.9,127.7];
zod36873a(2,:) = [50.3,84,86.3,87.5,88.5,89.4,89.7,89.9,91.2,91.7,92.3,92.9,93.6,94.2,94.8,...
    95.5,96.2,97.3,98.9,102.1,128.2];
zod36873a(3,:) = [90.1,90.9,91.2,91.6,91.9,92.3,92.7,93.1,93.5,93.9,94.3,94.7,95.2,95.7,...
    96.3,97.1,98.1,99.3,101.3,105,123.3];
zod36873a(4,:) = [90.2,91.5,92,92.5,92.9,93.3,93.7,94,94.4,94.7,95.1,95.5,95.9,96.4,96.9,...
    97.6,98.5,99.7,101.6,105,123.2];

%%  Data for the 3GPP 36.873 Phase 2 Calibration

cl36873b(1,:) = -[133.4,120.2,115.9,113,109.9,107.5,105.4,103.3,101.3,99.7,98,...
    96.3,94.6,92.8,90.8,88.6,85.8,81.8,75.8,69,51];
cl36873b(2,:) = -[136.8,121.8,117.9,114.9,112.2,109.4,107.1,104.7,102.5,100.4,...
    98.4,96.5,94.5,92.4,90.2,87.4,84.2,80.2,74,65.8,47.7];
cl36873b(3,:) = -[143.9,131.9,128.9,126.5,124.4,122.5,120.6,118.5,116.5,114.5,...
    112.2,110.2,108.3,106.4,104.3,102.1,99.6,96.4,92.1,84,59.9];
cl36873b(4,:) = -[146.9,131.5,128,125.5,123.3,121.2,119.2,117.2,115,112.9,110.9,...
    109,106.7,104.4,101.9,99.1,96,92.4,87.5,79.7,56.8];

sinr36873b(1,:) = [-7.8,-3.2,-2.1,-1.3,-0.6,0.1,0.6,1.2,2,2.7,3.6,4.4,5.3,6.5,7.7,9.2,11,...
    12.9,15.6,19.2,26.5];
sinr36873b(2,:) = [-7.2,-3,-1.9,-1,-0.2,0.5,1.1,1.8,2.6,3.4,4.3,5.3,6.3,7.5,8.9,10.6,12.5,...
    14.8,17.8,21.9,30.2];
sinr36873b(3,:) = [-8.3,-4,-2.9,-2.1,-1.4,-0.7,-0.1,0.5,1.1,1.8,2.6,3.5,4.4,5.4,6.5,7.7,9.4,...
    11.4,14.1,18,26.4];
sinr36873b(4,:) = [-7.8,-2.5,-1.4,-0.5,0.2,0.8,1.5,2.2,3,3.9,4.7,5.8,6.9,8.1,9.5,11.2,13.2,...
    15.6,18.2,22.2,32.9];

zsb36873b(1,:) = [0.1,0.5,0.8,1.1,1.4,1.8,2.1,2.5,2.8,3.2,3.7,4.2,4.9,5.6,6.6,7.7,9.3,11.4,...
    15.3,22.9,53.4];
zsb36873b(2,:) = [0.1,0.8,1.2,1.6,1.9,2.3,2.7,3.1,3.5,4,4.5,5.1,5.8,6.8,7.8,9.1,10.7,13.2,...
    17.4,26.5,53.4];
zsb36873b(3,:) = [0,0.2,0.3,0.4,0.6,0.8,0.9,1.1,1.3,1.5,1.8,2.1,2.5,2.9,3.5,4.2,5.2,6.7,9,...
    14.2,53.6];
zsb36873b(4,:) = [0.1,0.3,0.5,0.7,0.9,1.2,1.4,1.7,1.9,2.2,2.5,2.9,3.3,3.8,4.5,5.3,6.4,8,10.5,...
    15.8,52];

zsa36873b(1,:) = [1.4,3.4,3.9,4.3,4.8,5.3,5.9,6.5,7.2,8.1,9,9.9,11.2,12.6,14.4,16.8,20,24.4,...
    31,40.8,54];
zsa36873b(2,:) = [1.5,3.2,3.9,4.5,5.2,5.9,6.6,7.3,8.1,8.9,9.9,10.9,12.2,13.7,15.7,18.1,21.4,...
    25.9,32.5,42.4,55.8];
zsa36873b(3,:) = [2.8,3.6,4.3,5,5.8,6.6,7.5,8.4,9.4,10.6,11.7,12.9,14.6,16.3,18.3,20.6,23.5,...
    27.6,33,41.2,58];
zsa36873b(4,:) = [2.8,3.7,4.4,5.1,5.9,6.9,7.8,8.8,10,11.2,12.4,13.9,15.6,17.3,19.5,21.8,24.6,...
    28.4,34.1,42.9,56.6];

sv1_36873b(1,:) = [-10.8,5.1,6.9,8.1,9,9.7,10.4,11,11.5,12,12.5,13,13.5,14,14.5,15.1,15.6,...
    16.1,16.9,18,24.7];
sv1_36873b(2,:) = [-13.6,3.5,5.7,7.3,8.7,9.7,10.6,11.5,12.3,13.1,13.8,14.6,15.3,16.1,17,...
    17.9,18.9,19.9,21.3,23.3,35.3];
sv1_36873b(3,:) = [-9.6,5.3,7.1,8.1,9,9.7,10.4,11,11.5,12.1,12.6,13.1,13.6,14.1,14.6,15.1,...
    15.7,16.3,17,18.2,24.6];
sv1_36873b(4,:) = [-15.7,4.9,7.5,9.3,10.6,11.7,12.7,13.5,14.3,15.1,15.9,16.6,17.3,18.1,...
    18.9,19.7,20.6,21.5,22.8,24.7,35.9];

sv2_36873b(1,:) = [-48.6,-19.1,-13.8,-11,-8.9,-7.4,-6,-4.9,-4,-3.2,-2.3,-1.5,-0.8,0,0.8,...
    1.7,2.6,3.5,4.7,6.2,14.4];
sv2_36873b(2,:) = [-32.4,-6.2,-3.3,-1.5,-0.1,1,2,3,3.8,5,6,7,8,9,10.1,11.2,12.3,13.5,15,...
    17.5,31.6];
sv2_36873b(3,:) = [-46.2,-16,-11.9,-9.8,-8.2,-6.7,-5.6,-4.6,-3.7,-2.8,-2,-1.3,-0.5,0.3,...
    1.1,1.9,2.8,3.8,5,6.6,14.7];
sv2_36873b(4,:) = [-27.8,-4.4,-1.5,0.4,1.8,3,4,5,5.8,6.7,7.5,8.3,9.1,10,10.8,11.8,12.8,...
    14,15.7,18.7,33.4];

svR_36873b(1,:) = [0.3,5.4,7,8.2,9.2,10.2,11.1,11.9,12.8,13.6,14.4,15.3,16.2,17.2,18.3,...
    19.6,21.2,23.1,26,31.6,64.1];
svR_36873b(2,:) = [0.1,1.9,2.6,3.3,3.8,4.3,4.9,5.3,5.8,6.2,6.7,7.2,7.8,8.5,9.1,9.8,10.7,...
    11.7,12.8,14.7,36.1];
svR_36873b(3,:) = [0.3,5.3,6.9,8.1,9.2,10.1,11,11.8,12.6,13.4,14.3,15.2,16,17,18,19.2,20.5,...
    22.1,24.4,28.1,61.7];
svR_36873b(4,:) = [0.1,2.1,2.9,3.5,4.1,4.7,5.2,5.7,6.1,6.6,7.1,7.6,8,8.6,9.2,9.8,10.8,11.7,...
    12.7,14.7,36.5];

%%  Data for the 3GPP 38.901 Large Scale Calibration

cl38900a(1,:,1) = -[142.3,136.4,132.4,128.9,125.8,122.9,120.3,117.6,115,112.2,109.5,106.4,103.2,...
    99.9,96.2,92.2,87.6,82,74.8];
cl38900a(2,:,1) = -[164.6,158.5,154.1,150.3,147.1,144,141.1,138.2,135.3,132.4,129.4,126.2,122.5,...
    118.3,113.7,108.9,103.5,97.1,89.3];
cl38900a(3,:,1) = -[184.2,177.8,173.3,169.2,165.5,162,158.7,155.5,152.3,149.1,145.8,142.4,138.3,...
    133.6,127.1,119.8,112.8,105.2,96.8];
cl38900a(1,:,2) = -[150.4,144.7,140.6,137,133.9,131.1,128.4,125.8,123.1,120.3,117.5,114.7,111.8,...
    109.1,106.1,102.8,98.8,93.7,86];
cl38900a(2,:,2) = -[172,166.3,161.8,157.9,154.5,151.4,148.5,145.7,142.9,140.1,137,133.6,130,...
    126.6,123.1,119.5,115.4,110.1,102];
cl38900a(3,:,2) = -[191.4,185.5,180.9,176.8,172.8,169.2,165.8,162.6,159.6,156.6,153.3,149.8,...
    145.5,140.4,135.1,130.4,125.5,119.7,110.7];
cl38900a(1,:,3) = -[71.1,69.4,68.3,67.2,66.2,65.1,63.8,62.3,60.8,59.3,57.8,56.4,55,53.6,52.1,...
    50.7,49,47.2,45];
cl38900a(2,:,3) = -[85,83.5,82.3,81.3,80.3,79.2,77.9,76.4,74.9,73.3,71.8,70.3,68.9,67.5,66,64.6,...
    63,61.2,59.1];
cl38900a(3,:,3) = -[92.4,90.8,89.7,88.6,87.6,86.5,85.3,83.8,82.2,80.7,79.2,77.8,76.4,74.9,73.5,...
    71.9,70.4,68.6,66.4];

gf38900a(1,:,1)= [-1.7,-0.5,0.4,1.2,2.1,3,4,5,6.1,7.3,8.6,9.9,11.4,13,14.9,17,19.4,22.1,24.9];
gf38900a(2,:,1)= [-1.6,-0.4,0.4,1.3,2.2,3.1,4.1,5.2,6.3,7.5,8.8,10.2,11.7,13.3,15.1,17.2,19.6,22.2,24.9];
gf38900a(3,:,1)= [-1.6,-0.4,0.5,1.3,2.2,3.1,4.1,5.2,6.3,7.5,8.8,10.2,11.7,13.4,15.2,17.3,19.7,22.4,25];
gf38900a(1,:,2)= [-1,0.1,1.1,2,2.9,3.9,5,6,7.2,8.6,9.9,11.3,12.9,14.7,16.5,18.6,20.9,23.4,25.6];
gf38900a(2,:,2)= [-1,0.2,1.1,2,3,4,5,6.1,7.3,8.6,9.9,11.3,13,14.7,16.5,18.6,20.9,23.4,25.6];
gf38900a(3,:,2)= [-0.9,0.1,1.1,2,3,3.9,5,6.1,7.2,8.5,9.9,11.3,13,14.7,16.5,18.6,20.9,23.4,25.6];
gf38900a(1,:,3)= [-4.4,-3.5,-2.7,-2,-1.3,-0.6,0.2,1,2,3,4.2,5.5,6.9,8.4,10,11.7,13.6,15.6,17.9];
gf38900a(2,:,3)= [-4.3,-3.4,-2.7,-2,-1.3,-0.6,0.2,1.1,2,3.1,4.2,5.6,7,8.5,10.2,11.8,13.6,15.6,18];
gf38900a(3,:,3)= [-4.3,-3.4,-2.6,-1.9,-1.2,-0.5,0.3,1.1,2,3.1,4.3,5.5,6.9,8.4,10.1,11.7,13.6,15.6,18];

%%  Data for the 3GPP 38.901 Full Calibration
% dimensions: [ Freq, percentile (5:5:95), scenario (UMi, UMa, Indoor), Configuration ];

% Coupling Loss, UMi
cl38900b(1,:,1,1) = -[132.3,127.5,123.7,120.7,117.9,115.5,112.9,110.7,108.5,106.2,103.8,101.4,98.9,96.4,93.6,90.6,87.3,83.1,77.4];
cl38900b(2,:,1,1) = -[154.8,149.6,145.7,142.2,139.1,136.3,133.6,130.9,128.3,125.7,123.1,120.4,117.3,114.3,111.1,107.4,103.3,98.6,92.6];
cl38900b(3,:,1,1) = -[170.3,165,160.9,157.2,153.8,150.8,147.8,144.8,141.8,139,136.1,133,129.8,125.9,121.6,116.4,111.3,105.7,99.2];
cl38900b(4,:,1,1) = -[174.3,169.1,165.1,161.4,158.1,154.9,151.8,148.8,145.7,142.7,139.8,136.5,133.2,129.5,124.5,118.7,113.1,107.4,101];
cl38900b(1,:,1,2) = -[135.7,130.8,127,124,121.1,118.7,116.4,114.1,111.9,109.6,107.3,105,102.6,100.2,97.5,94.6,91.3,87.4,82.3];
cl38900b(2,:,1,2) = -[157.9,152.7,149.1,145.7,142.7,140,137.3,134.6,132,129.4,126.8,124.1,121.4,118.5,115.3,111.4,107.5,102.9,97.2];
cl38900b(3,:,1,2) = -[173.6,168.1,164.2,160.6,157.3,154.3,151.3,148.3,145.4,142.5,139.7,136.7,133.4,130,125.8,120.4,115,109.6,103.5];
cl38900b(4,:,1,2) = -[177.7,172.4,168.3,164.7,161.5,158.3,155.2,152.1,148.9,145.8,143,139.9,136.8,133.1,128.4,122.6,116.8,111,104.8];

% Coupling Loss, UMa
cl38900b(1,:,2,1) = -[147.1,141.4,137.4,133.8,130.7,127.9,125.3,122.8,120.4,118,115.7,113.3,111.1,108.7,106,102.9,99.5,95,88.8];
cl38900b(2,:,2,1) = -[167.3,161.9,157.9,154.3,151,148,145.4,142.7,140.1,137.3,134.6,131.7,128.9,126,123.2,120,116.3,111.6,104.8];
cl38900b(3,:,2,1) = -[182.6,177,172.7,169,165.3,161.9,158.9,156,153.3,150.4,147.3,144,140.4,136.6,133,129.2,125.1,119.5,111.5];
cl38900b(4,:,2,1) = -[186.8,181.3,176.8,172.9,169.3,165.8,162.7,159.6,156.7,153.8,150.7,147.3,143.5,139.3,135.1,131.2,126.6,120.9,112.3];
cl38900b(1,:,2,2) = -[151.4,145.7,141.6,138.3,135.4,132.7,130.2,127.6,125.2,122.9,120.6,118.4,116.1,113.6,111,107.9,104.5,99.9,93.5];
cl38900b(2,:,2,2) = -[172.8,167.1,162.9,159.2,156.2,153.1,150.4,147.8,145.2,142.4,139.6,136.6,134,131.3,128.5,125.1,121,116,108.7];
cl38900b(3,:,2,2) = -[188.5,182.4,178,174.1,170.5,167.1,164,161.3,158.4,155.6,152.5,149.1,145.5,141.7,138.2,134.6,130,123.6,115.7];
cl38900b(4,:,2,2) = -[192.6,186.9,182.3,178.3,174.6,171.3,168.2,165.2,162.4,159.4,156.2,152.7,149.1,144.9,140.9,137.1,132.3,125.8,117.2];

% Coupling Loss, InH
cl38900b(1,:,3,1) = -[67.6,65.6,64.3,63.2,62.3,61.5,60.7,59.9,59.1,58.3,57.5,56.7,55.9,55,54,52.9,51.7,50.2,48.2];
cl38900b(2,:,3,1) = -[80.7,78.8,77.5,76.5,75.6,74.8,74,73.2,72.5,71.8,71.1,70.3,69.5,68.6,67.7,66.7,65.6,64.1,62.2];
cl38900b(3,:,3,1) = -[86.8,84.9,83.5,82.5,81.7,80.8,80,79.3,78.5,77.8,77.1,76.3,75.5,74.7,73.8,72.8,71.7,70.2,68.2];
cl38900b(4,:,3,1) = -[88.3,86.3,85,83.9,82.9,82.1,81.3,80.6,79.9,79.1,78.4,77.6,76.8,75.9,75,74,72.9,71.5,69.4];
cl38900b(1,:,3,2) = -[68.8,67.5,66.7,66,65.4,64.9,64.4,63.9,63.4,62.9,62.4,61.9,61.4,60.9,60.3,59.6,58.9,57.9,56.4];
cl38900b(2,:,3,2) = -[82.8,81.5,80.7,80,79.4,78.8,78.3,77.8,77.4,76.9,76.4,75.9,75.4,74.9,74.3,73.6,72.8,71.9,70.4];
cl38900b(3,:,3,2) = -[88.9,87.6,86.7,86,85.4,84.9,84.4,83.9,83.4,82.9,82.5,82,81.5,80.9,80.3,79.7,78.9,77.8,76.4];
cl38900b(4,:,3,2) = -[90,88.8,87.9,87.3,86.7,86.1,85.6,85.2,84.7,84.2,83.7,83.3,82.8,82.2,81.7,81,80.2,79.2,77.7];

% Wideband SINR, UMi
sinr38900(1,:,1,1) = [-3.5,-2.3,-1.5,-0.8,-0.1,0.5,1.2,1.9,2.6,3.5,4.4,5.4,6.5,7.8,9.2,11,13.2,16.3,21];
sinr38900(2,:,1,1) = [-3.3,-2.2,-1.4,-0.6,0.1,0.7,1.4,2.1,2.8,3.6,4.5,5.5,6.7,8,9.6,11.3,13.6,16.6,21.3];
sinr38900(3,:,1,1) = [-3.3,-2.1,-1.3,-0.5,0.1,0.7,1.4,2.1,2.9,3.7,4.6,5.7,6.8,8.2,9.6,11.4,13.7,16.7,21.6];
sinr38900(4,:,1,1) = [-3.2,-2.1,-1.2,-0.5,0.1,0.8,1.4,2.2,3,3.8,4.7,5.8,6.9,8.3,9.8,11.6,13.8,17,21.8];
sinr38900(1,:,1,2) = [-3.8,-2.7,-1.9,-1.2,-0.6,-0,0.5,1.1,1.8,2.5,3.2,4.1,5,6.1,7.3,8.8,10.8,13.2,16.7];
sinr38900(2,:,1,2) = [-3.7,-2.6,-1.8,-1.1,-0.5,0.1,0.7,1.3,1.9,2.6,3.4,4.2,5.3,6.3,7.6,9.1,10.9,13.2,16.8];
sinr38900(3,:,1,2) = [-3.6,-2.6,-1.8,-1.1,-0.5,0.1,0.7,1.3,2,2.7,3.4,4.3,5.3,6.3,7.6,9.2,11,13.4,16.8];
sinr38900(4,:,1,2) = [-3.6,-2.5,-1.8,-1,-0.4,0.1,0.7,1.3,2,2.7,3.5,4.4,5.4,6.5,7.8,9.2,11,13.4,16.9];

% Wideband SINR, UMa
sinr38900(1,:,2,1) = [-3.1,-1.9,-1,-0.2,0.5,1.2,1.9,2.7,3.5,4.4,5.4,6.6,7.8,9.2,10.9,13,15.5,18.8,24.5];
sinr38900(2,:,2,1) = [-3.2,-2,-1.1,-0.4,0.3,0.9,1.7,2.5,3.3,4.3,5.2,6.4,7.6,8.9,10.6,12.6,15.1,18.5,24];
sinr38900(3,:,2,1) = [-3.2,-2.1,-1.2,-0.5,0.2,0.9,1.7,2.6,3.4,4.4,5.4,6.5,7.7,9,10.6,12.6,15,18.3,23.9];
sinr38900(4,:,2,1) = [-3.3,-2.1,-1.3,-0.5,0.2,0.9,1.7,2.5,3.3,4.2,5.2,6.4,7.6,9,10.5,12.5,14.9,18.2,23.3];
sinr38900(1,:,2,2) = [-3.7,-2.6,-1.8,-1.1,-0.4,0.2,0.8,1.4,2.1,2.9,3.8,4.6,5.6,6.8,8.1,9.7,11.6,14.2,18.1];
sinr38900(2,:,2,2) = [-3.7,-2.6,-1.8,-1.1,-0.4,0.2,0.8,1.4,2.2,2.9,3.8,4.7,5.7,6.9,8.2,9.8,11.7,14.2,17.9];
sinr38900(3,:,2,2) = [-3.6,-2.5,-1.7,-1,-0.3,0.2,0.8,1.5,2.2,3,3.8,4.8,5.8,7,8.3,9.8,11.8,14.3,18.1];
sinr38900(4,:,2,2) = [-3.7,-2.6,-1.8,-1.1,-0.4,0.2,0.8,1.4,2.1,2.9,3.8,4.7,5.7,6.9,8.4,9.9,11.7,14.2,18];

% Wideband SINR, InH
sinr38900(1,:,3,1) = [-4,-3.1,-2.4,-1.8,-1.3,-0.8,-0.2,0.3,0.8,1.4,2,2.7,3.5,4.4,5.3,6.4,7.8,9.5,11.9];
sinr38900(2,:,3,1) = [-4.3,-3.4,-2.7,-2.2,-1.7,-1.1,-0.6,-0.1,0.4,0.9,1.5,2.1,2.8,3.6,4.5,5.4,6.6,8.1,10.6];
sinr38900(3,:,3,1) = [-4.2,-3.4,-2.8,-2.2,-1.6,-1.1,-0.6,-0.1,0.3,0.9,1.4,2,2.7,3.5,4.4,5.4,6.5,8,10.3];
sinr38900(4,:,3,1) = [-4.2,-3.4,-2.8,-2.2,-1.7,-1.1,-0.7,-0.2,0.3,0.8,1.4,2,2.7,3.5,4.4,5.4,6.5,8.1,10.5];
sinr38900(1,:,3,2) = [-5.3,-4.6,-4,-3.5,-3.1,-2.7,-2.3,-1.9,-1.6,-1.1,-0.8,-0.3,0.2,0.7,1.3,2,2.8,3.9,5.5];
sinr38900(2,:,3,2) = [-5.6,-4.8,-4.3,-3.9,-3.4,-3,-2.7,-2.3,-1.9,-1.5,-1.1,-0.7,-0.2,0.4,1,1.7,2.5,3.5,5];
sinr38900(3,:,3,2) = [-5.6,-4.9,-4.3,-3.9,-3.5,-3.1,-2.7,-2.3,-1.9,-1.5,-1.1,-0.7,-0.2,0.3,0.9,1.6,2.4,3.4,4.9];
sinr38900(4,:,3,2) = [-5.5,-4.7,-4.2,-3.8,-3.4,-3,-2.6,-2.2,-1.9,-1.4,-1,-0.6,-0.1,0.4,1,1.7,2.5,3.5,5];

% Delay Spread
ds38900(1,:,1) = [27.7,47.3,65.8,83.5,101.1,118.6,135.8,154.1,173.7,196.6,219.3,244.9,276.1,309,351.1,401.4,469.1,579,787.5];
ds38900(2,:,1) = [19.5,36.9,57.9,79.1,96.3,115.2,133.4,153.4,173.6,195,217,242.6,273.7,309.5,350.3,404.4,475.4,584.7,792.4];
ds38900(3,:,1) = [16.2,31.3,51.8,72.4,92.5,112.1,130.6,150,171.2,193.8,217.7,243.9,275,309,354.2,409,479.8,587.5,789.1];
ds38900(4,:,1) = [15.8,31.9,52,72.6,93.4,112.6,131.6,151.1,174.5,196.1,219.5,246.4,277.6,315.2,360.8,417.7,491.5,602.8,803.2];
ds38900(1,:,2) = [48.5,74,93.7,112.4,130.1,148.2,167.1,186.8,207.9,230.9,256.4,285.9,319.3,360.9,406.5,470.1,553.1,685.9,956.3];
ds38900(2,:,2) = [46.9,71.1,90.6,109.6,128,145.4,162.5,182.5,202,224.1,249,277.5,308.9,348.1,391.9,448.5,527,649,871.1];
ds38900(3,:,2) = [43,68.6,88.4,106.8,123.9,141.4,158.6,178,198.7,219.9,244.4,272.6,304.9,342.8,387.1,441.7,518.7,629.7,847.7];
ds38900(4,:,2) = [43.3,69.2,89.3,107.7,125.4,142.6,160.1,178.2,198.8,220.6,245.6,273.4,303.6,340.4,386.8,439.4,518.8,635,850];
ds38900(1,:,3) = [3.8,5.1,6.3,7.5,8.7,9.9,11.2,12.6,14.1,15.8,17.7,19.9,22.4,25.4,29.1,33.7,40.1,50.3,69.3];
ds38900(2,:,3) = [4.8,6.3,7.6,8.7,9.8,10.9,12.1,13.4,14.6,16,17.4,19.1,20.9,23,25.6,28.6,32.8,38.8,51];
ds38900(3,:,3) = [5.4,6.8,8,9.1,10.1,11.1,12.2,13.2,14.3,15.6,16.9,18.3,19.9,21.7,23.8,26.4,29.6,34.8,43.5];
ds38900(4,:,3) = [5.3,6.7,7.9,9,9.9,11,12.1,13.1,14.1,15.3,16.6,18,19.5,21.3,23.4,25.8,29.1,33.7,42.3];

% ASD
asd38900(1,:,1) = [6,7.2,8.5,9.8,11.1,12.6,14.1,15.8,17.7,19.7,21.8,24.3,27.2,30.7,35,40.5,48.4,59.9,77.7];
asd38900(2,:,1) = [5.9,7.1,8.4,9.8,11,12.3,13.8,15.4,17.2,19.2,21.5,24.1,27.2,30.7,34.9,40.7,48.5,60.4,78.4];
asd38900(3,:,1) = [5.8,7,8.3,9.6,10.8,12,13.5,15.1,16.8,18.8,20.9,23.5,26.4,29.9,34.4,40.4,47.9,60.2,77.2];
asd38900(4,:,1) = [5.8,7,8.3,9.7,10.8,12.1,13.5,15.2,16.8,18.8,21.1,23.7,26.7,30.2,34.9,40.8,48.5,60.8,78.2];
asd38900(1,:,2) = [6.4,7.7,9,10.2,11.6,13,14.6,16.2,18.2,20.2,22.3,24.9,27.7,31.3,35.5,41,48.6,60.2,77.5];
asd38900(2,:,2) = [6.4,7.8,9.1,10.4,11.6,13.1,14.6,16.3,18.2,20.2,22.4,24.7,27.7,31.2,35.3,40.5,48,59.4,77.2];
asd38900(3,:,2) = [6.4,7.8,9.1,10.4,11.8,13.2,14.6,16.2,18,20,22.1,24.6,27.5,30.9,34.9,40.4,47.7,59,76.5];
asd38900(4,:,2) = [6.5,7.8,9.1,10.4,11.8,13.2,14.6,16.3,18,19.9,22.1,24.4,27.1,30.5,34.4,39.7,46.3,58,75.5];
asd38900(1,:,3) = [16.5,19.9,22.4,24.5,26.4,28.3,30,31.7,33.5,35.3,37.2,39.3,41.5,44,46.7,49.8,53.6,58.6,66.4];
asd38900(2,:,3) = [17.1,20.3,22.7,24.8,26.7,28.6,30.3,32.1,34,35.8,37.8,39.8,42,44.5,47.3,50.5,54.4,59.5,67.1];
asd38900(3,:,3) = [17.3,20.6,23,25.1,27.1,28.9,30.6,32.4,34.3,36.1,38,39.9,42.1,44.5,47.1,50.2,53.6,58.7,66];
asd38900(4,:,3) = [16.8,20.2,22.7,24.7,26.7,28.5,30.4,32.2,34,36,38,40.1,42.4,44.9,47.6,50.8,54.4,59.4,67.1];

% ZSD
zsd38900(1,:,1) = [0.26,0.33,0.38,0.44,0.5,0.56,0.63,0.7,0.79,0.87,0.98,1.12,1.27,1.46,1.7,2.04,2.52,3.25,5];
zsd38900(2,:,1) = [0.26,0.32,0.38,0.44,0.5,0.56,0.62,0.7,0.78,0.87,0.98,1.12,1.28,1.48,1.73,2.06,2.54,3.3,4.97];
zsd38900(3,:,1) = [0.26,0.32,0.38,0.43,0.49,0.55,0.62,0.69,0.77,0.87,0.98,1.1,1.26,1.47,1.71,2.06,2.51,3.24,4.87];
zsd38900(4,:,1) = [0.27,0.33,0.38,0.44,0.49,0.56,0.62,0.7,0.77,0.86,0.97,1.1,1.25,1.44,1.68,2.02,2.46,3.29,5.04];
zsd38900(1,:,2) = [0.22,0.34,0.5,0.68,0.85,1.03,1.23,1.43,1.66,1.93,2.22,2.59,3.03,3.58,4.25,5.17,6.52,8.75,13.22];
zsd38900(2,:,2) = [0.22,0.35,0.5,0.67,0.85,1.02,1.22,1.43,1.65,1.88,2.17,2.52,2.92,3.46,4.1,4.99,6.33,8.43,12.81];
zsd38900(3,:,2) = [0.22,0.35,0.5,0.66,0.84,1.02,1.22,1.41,1.64,1.89,2.19,2.54,2.96,3.5,4.22,5.19,6.56,8.72,13.22];
zsd38900(4,:,2) = [0.23,0.35,0.52,0.68,0.85,1.02,1.21,1.41,1.63,1.89,2.2,2.56,3,3.54,4.21,5.16,6.44,8.66,13.13];
zsd38900(1,:,3) = [4.88,5.71,6.43,7.1,7.75,8.38,9.04,9.7,10.42,11.2,12.02,12.87,13.86,14.97,16.26,17.82,19.79,22.51,27.04];
zsd38900(2,:,3) = [0.52,0.62,0.72,0.81,0.9,0.99,1.1,1.21,1.33,1.46,1.61,1.8,2,2.25,2.55,2.94,3.47,4.43,6.56];
zsd38900(3,:,3) = [0.19,0.23,0.26,0.3,0.33,0.37,0.41,0.46,0.51,0.56,0.62,0.7,0.78,0.89,1.03,1.2,1.44,1.87,3.36];
zsd38900(4,:,3) = [0.15,0.18,0.21,0.24,0.27,0.3,0.34,0.38,0.42,0.46,0.52,0.58,0.66,0.75,0.86,1.03,1.27,1.66,3.06];

% ASA
asa38900(1,:,1) = [26.4,34,38.7,42.5,45.7,48.7,51.6,54.5,57.4,60.3,63.4,66.5,69.6,73,76.6,80.3,84.2,88.6,94.5];
asa38900(2,:,1) = [25.2,32.5,37.9,41.9,45.3,48.4,51.4,54.2,57.3,60.4,63.3,66.4,69.6,72.8,76.3,80.1,84.3,88.8,94.7];
asa38900(3,:,1) = [24.3,31.9,37.3,41.3,44.8,47.9,50.9,53.9,56.8,59.8,62.8,65.8,69.2,72.4,75.9,79.4,83.5,88.3,93.9];
asa38900(4,:,1) = [25,32.4,37.5,41.5,45.1,48.1,51.1,53.9,56.9,59.8,62.8,66.1,69.2,72.6,76,79.8,83.9,88.5,93.9];
asa38900(1,:,2) = [32,38.1,42.4,45.8,48.9,51.7,54.5,57.2,60,62.8,65.8,68.7,71.6,74.7,78,81.5,85.3,89.5,95];
asa38900(2,:,2) = [32.4,37.9,41.8,44.8,47.5,50,52.5,55.1,57.6,60.2,62.9,65.8,68.8,71.8,75.2,78.8,82.5,86.8,92.7];
asa38900(3,:,2) = [30.9,36.4,40,42.9,45.6,48.3,50.9,53.6,56.3,58.9,62,64.9,67.9,71.1,74.5,78.2,82.1,86.8,92.2];
asa38900(4,:,2) = [30.3,35.4,38.7,41.6,44.2,46.9,49.6,52.3,54.9,57.6,60.5,63.5,66.6,69.7,73.1,76.8,80.9,85.7,91.9];
asa38900(1,:,3) = [23.2,29.4,33,35.5,37.6,39.5,41.2,42.9,44.5,46.2,47.8,49.5,51.3,53.2,55.3,57.8,60.6,64.1,69.8];
asa38900(2,:,3) = [16.8,20.2,22.6,24.6,26.4,28.3,30.1,31.9,33.6,35.4,37.3,39.4,41.6,44.1,46.8,50,53.5,58.2,66];
asa38900(3,:,3) = [13.4,16.3,18.4,20.6,22.5,24.3,26,27.9,29.8,31.7,33.6,35.9,38.2,40.7,43.5,46.6,50.6,55.9,63.6];
asa38900(4,:,3) = [12.7,15.5,17.7,19.5,21.3,23.1,24.8,26.6,28.4,30.3,32.2,34.5,36.9,39.5,42.4,45.8,49.9,55.3,64.1];

% ZSA
zsa38900(1,:,1) = [5.6,6.5,6.88,7.26,7.67,8.13,8.67,9.33,10.12,11.07,12.2,13.5,15.14,17.25,19.75,22.82,26.68,31.53,38.54];
zsa38900(2,:,1) = [5.39,6.45,6.81,7.18,7.56,8.02,8.54,9.13,9.9,10.81,11.88,13.15,14.79,16.81,19.34,22.35,26.25,31.27,37.79];
zsa38900(3,:,1) = [5.27,6.36,6.76,7.12,7.49,7.92,8.45,9.07,9.78,10.67,11.81,13.12,14.7,16.75,19.17,22.32,26.39,31.33,37.58];
zsa38900(4,:,1) = [5.29,6.34,6.74,7.09,7.49,7.94,8.43,9.07,9.82,10.7,11.73,13.02,14.62,16.66,19.15,22.41,26.7,31.69,38.39];
zsa38900(1,:,2) = [6.36,6.76,7.25,7.84,8.52,9.23,9.97,10.82,11.77,12.89,14.11,15.57,17.27,19.24,21.57,24.49,27.95,32.52,38.37];
zsa38900(2,:,2) = [6.38,6.78,7.24,7.81,8.41,9.04,9.71,10.39,11.17,12.04,13.08,14.23,15.74,17.47,19.68,22.64,26.27,31.09,37.72];
zsa38900(3,:,2) = [6.36,6.78,7.25,7.76,8.28,8.85,9.46,10.1,10.77,11.56,12.55,13.71,15.18,17,19.22,22.18,26.04,30.84,37.51];
zsa38900(4,:,2) = [6.37,6.77,7.22,7.71,8.26,8.82,9.39,9.99,10.68,11.5,12.43,13.58,14.97,16.8,19.13,22.21,26.03,30.94,38.17];
zsa38900(1,:,3) = [7.82,8.53,9.03,9.46,9.86,10.24,10.62,11.01,11.41,11.83,12.27,12.74,13.24,13.82,14.48,15.25,16.25,17.71,20.23];
zsa38900(2,:,3) = [5.48,5.94,6.28,6.57,6.84,7.1,7.34,7.57,7.81,8.07,8.33,8.63,8.95,9.32,9.73,10.21,10.85,11.8,13.7];
zsa38900(3,:,3) = [4.54,4.96,5.23,5.47,5.68,5.88,6.09,6.27,6.47,6.68,6.88,7.12,7.37,7.64,7.95,8.33,8.81,9.51,10.86];
zsa38900(4,:,3) = [4.34,4.72,4.99,5.21,5.41,5.6,5.79,5.98,6.18,6.39,6.59,6.79,7.04,7.31,7.62,8,8.45,9.13,10.41];

% SV1
sv1_38900(1,:,1) = [3.62,5.27,6.38,7.2,7.9,8.52,9.1,9.63,10.13,10.61,11.09,11.57,12.06,12.54,13.05,13.59,14.21,15.04,16.27];
sv1_38900(2,:,1) = [3.62,5.27,6.35,7.16,7.88,8.5,9.08,9.62,10.12,10.62,11.1,11.58,12.06,12.55,13.06,13.6,14.23,15.03,16.26];
sv1_38900(3,:,1) = [3.62,5.28,6.36,7.19,7.9,8.52,9.09,9.62,10.13,10.63,11.1,11.59,12.06,12.56,13.05,13.6,14.2,15.02,16.23];
sv1_38900(4,:,1) = [3.64,5.32,6.39,7.22,7.92,8.54,9.1,9.63,10.15,10.64,11.14,11.61,12.07,12.56,13.06,13.61,14.22,15.02,16.23];
sv1_38900(1,:,2) = [3.54,5.18,6.23,7.09,7.79,8.43,9.01,9.54,10.04,10.53,11.01,11.48,11.97,12.47,12.98,13.53,14.18,15.02,16.24];
sv1_38900(2,:,2) = [3.55,5.11,6.17,6.99,7.68,8.29,8.87,9.42,9.94,10.43,10.91,11.39,11.87,12.37,12.9,13.45,14.1,14.94,16.16];
sv1_38900(3,:,2) = [3.57,5.17,6.21,7.03,7.71,8.34,8.91,9.44,9.95,10.44,10.93,11.41,11.9,12.39,12.91,13.47,14.1,14.93,16.17];
sv1_38900(4,:,2) = [3.49,5.11,6.17,7,7.71,8.32,8.88,9.41,9.9,10.41,10.89,11.37,11.85,12.34,12.85,13.42,14.07,14.91,16.12];
sv1_38900(1,:,3) = [2.82,4.67,5.88,6.81,7.6,8.26,8.83,9.38,9.88,10.37,10.78,11.18,11.58,11.95,12.33,12.73,13.11,13.58,14.35];
sv1_38900(2,:,3) = [2.85,4.77,6.03,6.98,7.77,8.42,8.99,9.52,10.03,10.47,10.89,11.28,11.67,12.03,12.39,12.77,13.16,13.6,14.35];
sv1_38900(3,:,3) = [2.69,4.73,6.02,6.98,7.77,8.41,8.95,9.47,9.96,10.41,10.84,11.23,11.62,11.98,12.33,12.69,13.06,13.5,14.2];
sv1_38900(4,:,3) = [3.04,4.95,6.13,7.08,7.86,8.49,9.05,9.56,10.07,10.51,10.92,11.31,11.69,12.06,12.42,12.78,13.17,13.61,14.33];

% SV2
sv2_38900(1,:,1) = [-23.43,-18.18,-15.35,-13.39,-11.82,-10.51,-9.35,-8.31,-7.34,-6.43,-5.55,-4.68,-3.81,-2.94,-2.04,-1.11,-0.06,1.15,2.77];
sv2_38900(2,:,1) = [-23.67,-18.22,-15.26,-13.24,-11.62,-10.29,-9.15,-8.1,-7.14,-6.23,-5.36,-4.52,-3.67,-2.81,-1.92,-1.01,0.02,1.25,2.86];
sv2_38900(3,:,1) = [-23.95,-18.54,-15.52,-13.42,-11.79,-10.41,-9.24,-8.16,-7.18,-6.26,-5.39,-4.54,-3.7,-2.85,-1.97,-1.04,-0.02,1.2,2.87];
sv2_38900(4,:,1) = [-23.49,-18.3,-15.42,-13.34,-11.72,-10.38,-9.22,-8.15,-7.18,-6.24,-5.38,-4.52,-3.68,-2.81,-1.93,-0.99,0.07,1.3,2.95];
sv2_38900(1,:,2) = [-19,-15.34,-13.1,-11.5,-10.19,-9.04,-8.04,-7.12,-6.26,-5.45,-4.63,-3.86,-3.09,-2.31,-1.5,-0.64,0.34,1.47,3.04];
sv2_38900(2,:,2) = [-19.36,-15.28,-13,-11.33,-10.01,-8.86,-7.84,-6.92,-6.07,-5.25,-4.46,-3.71,-2.95,-2.17,-1.38,-0.52,0.45,1.55,3.09];
sv2_38900(3,:,2) = [-19.58,-15.33,-12.98,-11.3,-9.96,-8.84,-7.83,-6.95,-6.09,-5.3,-4.52,-3.76,-3.01,-2.24,-1.44,-0.58,0.37,1.49,3];
sv2_38900(4,:,2) = [-19.88,-15.38,-13.02,-11.35,-10.02,-8.89,-7.88,-6.97,-6.12,-5.31,-4.53,-3.79,-3.04,-2.27,-1.46,-0.61,0.35,1.46,3.02];
sv2_38900(1,:,3) = -[38,34.61,31.92,29.77,27.87,26.1,24.26,22.55,20.88,19.34,17.73,16.24,14.76,13.29,11.85,10.44,8.9,7.1,4.77];
sv2_38900(2,:,3) = -[40.53,36.52,33.75,31.44,29.35,27.42,25.55,23.73,21.93,20.27,18.69,17.17,15.62,14.09,12.58,11.07,9.49,7.65,5.31];
sv2_38900(3,:,3) = -[41.41,37.45,34.66,32.32,30.19,28.19,26.25,24.47,22.76,21.13,19.49,17.84,16.33,14.87,13.35,11.81,10.16,8.23,5.81];
sv2_38900(4,:,3) = -[41.64,37.56,34.7,32.43,30.33,28.35,26.44,24.58,22.83,21.1,19.48,17.9,16.35,14.84,13.23,11.65,9.97,8.14,5.64];

% SV Ratio
svR_38900(1,:,1) = [6.5,8.3,9.7,10.8,11.9,12.9,13.9,14.9,15.9,16.8,17.8,18.9,20,21.2,22.6,24.2,26.2,29,34.4];
svR_38900(2,:,1) = [6.4,8.2,9.6,10.8,11.8,12.8,13.8,14.8,15.7,16.6,17.6,18.7,19.8,21,22.4,24,26.1,29,34.5];
svR_38900(3,:,1) = [6.5,8.3,9.6,10.8,11.9,12.9,13.8,14.8,15.8,16.7,17.7,18.8,19.9,21.1,22.5,24.1,26.3,29.4,34.8];
svR_38900(4,:,1) = [6.4,8.2,9.6,10.8,11.8,12.8,13.8,14.8,15.7,16.7,17.7,18.7,19.8,21.1,22.4,24.1,26.2,29.2,34.4];
svR_38900(1,:,2) = [6.2,7.9,9.2,10.3,11.3,12.3,13.2,14.1,14.9,15.8,16.7,17.6,18.6,19.7,20.9,22.3,24,26.2,30];
svR_38900(2,:,2) = [6.1,7.8,9.1,10.2,11.2,12.1,13,13.8,14.7,15.6,16.4,17.4,18.4,19.4,20.7,22.1,23.8,26.1,30.1];
svR_38900(3,:,2) = [6.1,7.8,9.1,10.2,11.2,12.2,13,13.9,14.8,15.6,16.5,17.4,18.4,19.5,20.7,22.1,23.8,26.1,30.5];
svR_38900(4,:,2) = [6.1,7.8,9.1,10.2,11.2,12.1,13,13.9,14.7,15.6,16.5,17.5,18.4,19.5,20.7,22.1,23.8,26.2,30.5];
svR_38900(1,:,3) = [12,15,17.1,19,20.8,22.4,24.1,25.8,27.5,29.3,31.1,32.9,34.8,36.7,38.5,40.5,42.7,45.4,49];
svR_38900(2,:,3) = [12.9,16,18.1,20,21.8,23.5,25.1,26.8,28.6,30.4,32.2,34.1,36,37.9,39.9,42.1,44.5,47.4,51.3];
svR_38900(3,:,3) = [13.5,16.5,18.8,20.7,22.5,24.3,26,27.6,29.4,31.1,33,34.8,36.7,38.7,40.7,42.9,45.3,48.1,52.2];
svR_38900(4,:,3) = [13.4,16.5,18.7,20.7,22.5,24.3,26,27.7,29.4,31.2,33.1,35,36.9,38.9,40.9,43.1,45.5,48.4,52.5];
